<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/ta/tawfiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/statecodes">

	<xsl:template name="Item2">
		<h3>
			Withdrawal Information
		</h3>
		<xsl:call-template name="withdrawalInfo" />
	</xsl:template>
	
	<xsl:template name="withdrawalInfo">

		
		<table role="presentation" >
			<tr>
				<b>6.</b> Furnish registrant's reasons for ceasing the performance of transfer agent functions or for 
				otherwise requesting the withdrawal of its registration:
			</tr>
			<tr>
				<td>
					<p>
						<div class="fakeBox3">
							<xsl:value-of
								select="string(p:formData/p:withdrawal/p:withdrawalDescription)" />
							<span>
								<xsl:text>&#160;</xsl:text>
							</span>
						</div>
					</p>
				</td>
			</tr>
		</table>
		
		<table role="presentation" >	
			<tr>
				<b>7.</b> Furnish the last date registrant performed transfer agent functions as defined by Section 3(a)(25) 
				of the Act for any security, including debt and equity, registered under Section 12 of the 
				Act or which would be required to be registered except for the exemption for 
				registration provided by subsection (g)(2)(B) or (g)(2)(G) of that section.
			</tr>
				<td>
					<p>
						<div align="left">
							<div class="fakeBox2">
								<xsl:value-of select="string(p:formData/p:withdrawal/p:lastActionDate)" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</div>
					</p>
				</td>			
				<tr>
					<td class="label"><b>7(a).</b> Does the registrant have any intention of performing in the near future a transfer agent function for any such security?</td>
					<td>							
						<xsl:choose>
							<xsl:when test="p:formData/p:withdrawal/p:futureTransferAgentFunctions = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes
						<xsl:choose>
							<xsl:when test="p:formData/p:withdrawal/p:futureTransferAgentFunctions = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No							
					</td>
				</tr>			
			</table>
	</xsl:template>
</xsl:stylesheet>